#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "gmstuff.h"
#include "map.h"
#include "switchstuff.h"
#include "wirestuff.h"

char *Mapfile;
char *Switchfile;
char *Tmpdir;
char Wiredir[256];
char *Wirelist;
char *Test_x1;
int Test_p1;
char *Test_x2;
int Test_p2;
int Hport = 0;
extern int My_host_id;


void
usage(char *progname)
{
    fprintf(stderr, "\nUsage: %s -s <switchlist> [-H <fms_run>] [-N <db_name>]\n",
	progname);
    fprintf(stderr, "-s <switchfile>: file containing switches in fabric (input)\n");
    fprintf(stderr, "-m <mapfile>:    mapfile from mapper (input)\n");
    fprintf(stderr, "-H <fms_run>:   wirelist (output)\n");
    fprintf(stderr, "-N <db_name>:    Directory for wirinfo in FMA input format (output)\n");

    fprintf(stderr, "\nTakes a map file generated by gm_mapper and a list of switch names\n");
    fprintf(stderr, "and generates the database files for use by other tools.\n");
}


void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;
  char *fms_run;
  char *db_name;

  Tmpdir = "/tmp";
  fms_run = getenv("FMS_RUN");
  db_name = getenv("FMS_DB_NAME");

  while ((c = getopt(argc, argv, "s:m:R:N:")) != EOF) switch (c) {

  case 'm':	/* map file (input) */
    Mapfile = optarg;
    break;

  case 's':	/* switch file (input) */
    Switchfile = optarg;
    break;

  case 'R':	/* FMS run dir (where database is stored) */
    fms_run = optarg;
    break;

  case 'N':  /* name of database */
    db_name = optarg;
    break;
  }

  if (Mapfile == NULL) {
    fprintf(stderr, "Map file is required!\n\n");
    usage(argv[0]);
    exit(1);
  }

  if (fms_run == NULL) fms_run = "/var/run/fms";
  if (db_name == NULL) db_name = "database";

  sprintf(Wiredir, "%s/%s", fms_run, db_name);
  /* create Wiredir */
  if (Wiredir != NULL) {
    if (mkdir(Wiredir, 0755) < 0 && errno != EEXIST) {
      perror(Wiredir);
      exit(1);
    }
  }


}

int
main(
  int argc,
  char **argv)
{
  struct mapfile mf;
  struct mapfile *mp;

  mp = &mf;
  parse_args(argc, argv);

  initialize_gm();

  mp->name = Mapfile;
  load_map_file(mp);
  find_self(mp);

  if (Hport >= mf.host[My_host_id].nport) {
    fprintf(stderr, "Requested host port number too big\n");
    exit(1);
  }

  calc_xbar_routes(mp);	/* calculate routes to all xbars */

  load_switch_file();

  create_wiring_list(mp);

  if (Wiredir != NULL)
    output_wiring_dir(mp);
  else
    output_wiring_list();

  close_gm();

  return 0;
}
